program game;

uses
  pHLevel2, Windows, Types, Fmod, Fmodtypes;

type
  //  
  TEnemy = record
    Draw, BulletDraw: DWORD;//id 
    _Type: Byte;// 
    Killed: Boolean;//   
    AIState: Byte;
    AIBulletPos: TUPoint;
  end;

const
  ST_GAME         = 0;
  ST_MENU         = 1;
  ST_PAUSE        = 2;
  ST_RETURN       = 3;
  ST_NEW_LEVEL    = 4;
  ST_GAME_OVER    = 5;
  EM_LEFT         = 0;
  EM_RIGHT        = 1;
  EM_DOWNL        = 2;
  EM_DOWNR        = 3;
  MENU_NEW_GAME   = 0;
  MENU_TWO        = 1;
  MENU_EXIT       = 2;
  AI_READY        = 0;
  AI_ATTACKING    = 1;

var
  hiScore: Pointer;
  sShoot, sKilled: Pointer;//
  sMove: array[0..3] of Pointer;
  menuText: array[0..2] of DWORD;// 
  enemySpr: array[0..3] of DWORD;// 
  enemyArray: array[0..11, 0..4] of TEnemy;//   
  enemyPos, playerPos: TUPoint;
  enemyMover, playerSpr, playerDrw, bulletMover, bulletsSpr, playerBulletDrw,
    bulletHeight, bulletX, currentScore, currentScoreTxt, hiScoreTxt, logoTxt, newLevelTxt,
    playerLivesTxt, playerLivesDrw, lives, AItimer, fpsTxt: DWORD;
  cMoveSnd: Byte = 0;
  cSndChValue: Boolean = True;
  menuSelect: Byte = 0;//  
  moveAct: Byte = EM_RIGHT;
  state: Byte = 255;

//  ,   bulletMover
procedure MoveBullet(param: DWORD); stdcall;
begin
  Inc(bulletHeight, 5);
  if bulletHeight > 300 then
  begin
    Timer.Enable(bulletMover, False);
    bulletHeight := 0;
    e2d.DelDraw(playerBulletDrw);
    playerBulletDrw := 0;  
  end else
    playerBulletDrw := e2d.Draw(playerBulletDrw, bulletsSpr, URect(bulletX, playerPos.Y - 12 - bulletHeight, 6, 12),
      ANIM_STATIC, 1, $FF000000, 1);
end;

// 
procedure StateDeInit(param: Byte);
var
  i, j: DWORD;
begin
  case state of
    ST_GAME:
      begin
        Timer.Enable(enemyMover, False);
        Timer.Enable(bulletMover, False);
        Timer.Enable(AItimer, False);
        for i := 0 to 11 do
          for j := 0 to 4 do
          begin
            e2d.DelDraw(enemyArray[i, j].Draw);
            e2d.DelDraw(enemyArray[i, j].BulletDraw);
          end;
        e2d.DelDraw(playerDrw);
        e2d.DelDraw(playerBulletDrw);
        e2d.DelDraw(playerLivesDrw);
        Txt.DelDraw(currentScoreTxt);
        Txt.DelDraw(hiScoreTxt);
        Txt.DelDraw(playerLivesTxt);
      end;
    ST_MENU, ST_PAUSE:
      begin
        Txt.DelDraw(logoTxt);
        for i := 0 to 2 do
          Txt.DelDraw(menuText[i]);
      end;
    ST_NEW_LEVEL, ST_GAME_OVER:
      Txt.DelDraw(newLevelTxt);
  end;
end;

// 
procedure StateInit(param: Byte);
var
  i, j, _type: DWORD;
begin
  if param = state then exit;
  StateDeInit(state);
  case param of
    ST_GAME:
      begin
        //  ,      
        currentScore := 0;
        lives := 2;
        enemyPos := UPoint(150, 100);
        playerPos := UPoint(305, 360);
        _type := 0;
        for i := 0 to 11 do
          for j := 0 to 4 do
            begin
              if j = 0 then _type := 2;
              if (j >= 1) and (j <= 2) then _type := 1;
              if (j >= 3) and (j <= 4) then _type := 0;   
              enemyArray[i, j]._Type := _type;
              enemyArray[i, j].Draw := e2d.Draw(0, enemySpr[_type], URect(enemyPos.X + i * 26, enemyPos.Y + j * 18, 26, 18),
                ANIM_START, 1, $FF000000, 1, 600, 0, True);
              enemyArray[i, j].Killed := False;
              enemyArray[i, j].AIState := 0;
            end;
        playerLivesDrw := e2d.Draw(0, playerSpr, URect(100, 380, 32, 20),
          ANIM_STATIC, 1, $FF000000, 1, 0, 0);
        playerDrw := e2d.Draw(0, playerSpr, URect(playerPos.X, playerPos.Y, 32, 20),
          ANIM_STATIC, 1, $FF000000, 1, 0, 0);
        playerLivesTxt := txt.Draw(0, PChar('x' + IntToStr(lives)), 'Fixedsys', Rect(140, 385, 0, 0), $FFFFFFFF, 12);
        currentScoreTxt := 0;
        hiScoreTxt := 0;
        currentScoreTxt := Txt.Draw(currentScoreTxt, PChar(': ' + IntToStr(currentScore)),
          'Fixedsys', Rect(100, 50, 0, 0), $FFFFFFFF, 12);
        hiScoreTxt := Txt.Draw(hiScoreTxt, PChar(': ' + IntToStr(Integer(hiScore^))),
          'Fixedsys', Rect(450, 50, 0, 0), $FFFFFFFF, 12);
        Timer.Enable(enemyMover, True);
        Timer.Enable(AItimer, True);
      end;
    ST_MENU:
      begin
        menuSelect := 0;
        logoTxt := Txt.Draw(0, 'Space Invaders', 'Fixedsys',
          Bounds(210, 120, 0, 0), $FF66FF66, 35, 256, FW_NORMAL, False);
        menuText[0] := Txt.Draw(0, ' ', 'Fixedsys',
          Bounds(280, 200, 0, 0), $FF66FF00, 12, 256, FW_NORMAL, False);
        menuText[1] := Txt.Draw(0, ' ', 'Fixedsys',
          Bounds(265, 220, 0, 0), $FFFFFFFF, 12, 256, FW_NORMAL, False);
        menuText[2] := Txt.Draw(0, '', 'Fixedsys',
          Bounds(297, 240, 0, 0), $FFFFFFFF, 12, 256, FW_NORMAL, False);
      end;
    ST_PAUSE:
      begin
        logoTxt := Txt.Draw(0, 'Space Invaders', 'Fixedsys',
          Bounds(210, 120, 0, 0), $FF66FF66, 35, 256, FW_NORMAL, False);
        menuText[0] := Txt.Draw(0, ' ', 'Fixedsys',
          Bounds(280, 200, 0, 0), $FF66FF00 or ($FFFFFFFF * Byte(menuSelect <> 0)), 12, 256, FW_NORMAL, False);
        menuText[1] := Txt.Draw(0, '', 'Fixedsys',
          Bounds(282, 220, 0, 0), $FF66FF00 or ($FFFFFFFF * Byte(menuSelect <> 1)), 12, 256, FW_NORMAL, False);
        menuText[2] := Txt.Draw(0, '', 'Fixedsys',
          Bounds(299, 240, 0, 0), $FF66FF00 or ($FFFFFFFF * Byte(menuSelect <> 2)), 12, 256, FW_NORMAL, False);
        menuSelect := 1;
      end;
    ST_RETURN:
      begin
        currentScoreTxt := Txt.Draw(currentScoreTxt, PChar(': ' + IntToStr(currentScore)),
          'Fixedsys', Rect(100, 50, 0, 0), $FFFFFFFF, 12);
        hiScoreTxt := Txt.Draw(hiScoreTxt, PChar(': ' + IntToStr(Integer(hiScore^))),
          'Fixedsys', Rect(450, 50, 0, 0), $FFFFFFFF, 12);      
        for i := 0 to 11 do
          for j := 0 to 4 do
            begin
              if enemyArray[i, j].Killed then Continue;
              enemyArray[i, j].Draw := e2d.Draw(0, enemySpr[enemyArray[i, j]._Type],
                URect(enemyPos.X + i * 26, enemyPos.Y + j * 18, 26, 18),
                ANIM_START, 1, $FF000000, 1, 600, 0, True);
              if enemyArray[i, j].AIState = AI_ATTACKING then
                enemyArray[i, j].BulletDraw := e2d.Draw(0,
                bulletsSpr, URect(enemyArray[i, j].AIBulletPos.X, enemyArray[i, j].AIBulletPos.Y, 6, 12),
                ANIM_START, 2 + enemyArray[i, j]._Type * 2, $FF000000, 1, 50, 3 + enemyArray[i, j]._Type * 2, True);              
            end;
        playerDrw := e2d.Draw(0, playerSpr, URect(playerPos.X, playerPos.Y, 32, 20),
          ANIM_STATIC, 1, $FF000000, 1, 0, 0);
        playerLivesDrw := e2d.Draw(0, playerSpr, URect(100, 380, 32, 20),
          ANIM_STATIC, 1, $FF000000, 1, 0, 0);
        playerLivesTxt := txt.Draw(0, PChar('x' + IntToStr(lives)), 'Fixedsys', Rect(140, 385, 0, 0), $FFFFFFFF, 12);      
        Timer.Enable(enemyMover, True);
        Timer.Enable(AItimer, True);
        param := ST_GAME;
      end;
    ST_NEW_LEVEL:
      begin
        newLevelTxt := Txt.Draw(0, ' ', 'Fixedsys',
          Bounds(210, 200, 0, 0), $FF66FF66, 35, 256, FW_NORMAL, False);
      end;
    ST_GAME_OVER:
      begin
        newLevelTxt := Txt.Draw(0, ' ', 'Fixedsys',
          Bounds(230, 200, 0, 0), $FF66FF66, 35, 256, FW_NORMAL, False);
      end;
  end;
  state := param;
end;

//  ,   enemyMover
procedure MoveEnemys(param: DWORD); stdcall;
var
  i, j: DWORD;
  AllKilled: Boolean;
begin
  //  
  case moveAct of
    EM_LEFT:
      begin
        Dec(enemyPos.X, 10);
        if enemyPos.X < 100 then moveAct := EM_DOWNR;
      end;
    EM_RIGHT:
      begin
        Inc(enemyPos.X, 10);
        if enemyPos.X > 246 then moveAct := EM_DOWNL;
      end;
    EM_DOWNL:
      begin
        Inc(enemyPos.Y, 10);
        moveAct := EM_LEFT;
      end;
    EM_DOWNR:
      begin
        Inc(enemyPos.Y, 10);
        moveAct := EM_RIGHT;
      end;
  end;
  if ((cMoveSnd = 0) and not cSndChValue) or ((cMoveSnd = 2) and cSndChValue) then
    cSndChValue := not cSndChValue;
  if cSndChValue then Inc(cMoveSnd) else Dec(cMoveSnd);
  FSOUND_PlaySound(FSOUND_FREE, sMove[cMoveSnd]);
  AllKilled := True;
  for i := 0 to 11 do
    for j := 0 to 4 do
      begin
        if enemyArray[i, j].Killed then Continue;
        enemyArray[i, j].Draw := e2d.Draw(enemyArray[i, j].Draw, enemySpr[enemyArray[i, j]._Type],
          URect(enemyPos.X + i * 26, enemyPos.Y + j * 18, 26, 18),
          ANIM_KEEP, 0, $FF000000, 1, 600, 0, True);
        AllKilled := False;  
      end;
  if AllKilled then 
    StateInit(ST_NEW_LEVEL);
end;

// ))
procedure Process; stdcall;
var
  i, j: DWORD;
  tmpRect: TRect;
begin
  fpsTxt := Txt.Draw(fpsTxt, PChar('FPS: ' + IntToStr(Eng.GetFPS)), 'Fixedsys', Rect(5, 5, 0, 0), $FFFFFFFF);
  case state of
    //  -  , 
    ST_GAME:
      begin
        if Inp.IsKeyPressed(VK_LEFT) and (playerPos.X > 100) then
          Dec(playerPos.X);
        if Inp.IsKeyPressed(VK_RIGHT) and (playerPos.X < 640 - 82 - 32) then
          Inc(playerPos.X);
        if Inp.IsKeyPressed(VK_UP) and not Timer.Enabled(bulletMover) then
        begin
          FSOUND_PlaySound(FSOUND_FREE, sShoot);
          bulletX := playerPos.X + 13;
          playerBulletDrw := e2d.Draw(0, bulletsSpr, URect(bulletX, playerPos.Y - 12, 6, 12),
            ANIM_STATIC, 1, $FF000000, 1);
          Timer.Enable(bulletMover, True);
          bulletHeight := 0;
        end;
        playerDrw := e2d.Draw(playerDrw, playerSpr, URect(playerPos.X, playerPos.Y, 32, 20),
          ANIM_STATIC, 1, $FF000000, 1, 0, 0);
        if Timer.Enabled(bulletMover) then
          for i := 0 to 11 do
            for j := 0 to 4 do
                if IntersectRect(tmpRect, Bounds(enemyPos.X + i * 26, -enemyPos.Y - j * 18, 26, 18),
                  Bounds(bulletX, -playerPos.Y + 12 + bulletHeight, 6, 12)) and not enemyArray[i, j].Killed then
                begin
                  FSOUND_PlaySound(FSOUND_FREE, sKilled);
                  enemyArray[i, j].Killed := True;
                  e2d.DelDraw(enemyArray[i, j].Draw);
                  enemyArray[i, j].Draw := 0;
                  Timer.Enable(bulletMover, False);
                  bulletHeight := 0;
                  e2d.DelDraw(playerBulletDrw);
                  playerBulletDrw := 0;
                  Inc(currentScore, (enemyArray[i, j]._Type + 1) * 10);
                  currentScoreTxt := Txt.Draw(currentScoreTxt, PChar(': ' + IntToStr(currentScore)),
                    'Fixedsys', Rect(100, 50, 0, 0), $FFFFFFFF, 12);
                  if Integer(currentScore) > Integer(hiScore^) then
                  begin
                    Integer(hiScore^) := currentScore;
                    hiScoreTxt := Txt.Draw(hiScoreTxt, PChar(': ' + IntToStr(Integer(hiScore^))),
                      'Fixedsys', Rect(450, 50, 0, 0), $FFFFFFFF, 12);
                  end;
                  Break;
                end;
      end;  
  end;
end;

procedure KbProc(Key: Word); stdcall;
var
  tmp, tmp1: DWORD;
begin
  if (state = ST_MENU) or (state = ST_PAUSE) then
    case Key of
      VK_UP:
        if menuSelect > 0 then Dec(menuSelect);
      VK_DOWN:
        if menuSelect < 2 then Inc(menuSelect);
    end;
  case state of
    ST_GAME:
      if Key = VK_ESCAPE then
        StateInit(ST_PAUSE);
    ST_MENU:
      begin
        if Key = VK_RETURN then
          case menuSelect of
            MENU_NEW_GAME:
              begin
                StateInit(ST_GAME);
                exit;
              end;
            MENU_TWO:
              begin
                Integer(hiScore^) := 0;
                exit;
              end;
            MENU_EXIT:
              Eng.TurnOff;
          end;
        menuText[0] := Txt.Draw(menuText[0], ' ', 'Fixedsys',
          Bounds(280, 200, 0, 0), $FF66FF00 or ($FFFFFFFF * Byte(menuSelect <> 0)), 12, 256, FW_NORMAL, False);
        menuText[1] := Txt.Draw(menuText[1], ' ', 'Fixedsys',
          Bounds(265, 220, 0, 0), $FF66FF00 or ($FFFFFFFF * Byte(menuSelect <> 1)), 12, 256, FW_NORMAL, False);
        menuText[2] := Txt.Draw(menuText[2], '', 'Fixedsys',
          Bounds(297, 240, 0, 0), $FF66FF00 or ($FFFFFFFF * Byte(menuSelect <> 2)), 12, 256, FW_NORMAL, False);
      end;
    ST_PAUSE:
      begin
        if Key = VK_RETURN then
          case menuSelect of
            MENU_NEW_GAME:
              begin
                StateInit(ST_GAME);
                exit;
              end;
            MENU_TWO:
              begin
                StateInit(ST_RETURN);
                exit;
              end;
            MENU_EXIT:
              Eng.TurnOff;
          end;
        menuText[0] := Txt.Draw(menuText[0], ' ', 'Fixedsys',
          Bounds(280, 200, 0, 0), $FF66FF00 or ($FFFFFFFF * Byte(menuSelect <> 0)), 12, 256, FW_NORMAL, False);
        menuText[1] := Txt.Draw(menuText[1], '', 'Fixedsys',
          Bounds(282, 220, 0, 0), $FF66FF00 or ($FFFFFFFF * Byte(menuSelect <> 1)), 12, 256, FW_NORMAL, False);
        menuText[2] := Txt.Draw(menuText[2], '', 'Fixedsys',
          Bounds(299, 240, 0, 0), $FF66FF00 or ($FFFFFFFF * Byte(menuSelect <> 2)), 12, 256, FW_NORMAL, False);
      end;
    ST_NEW_LEVEL:
      if Key = VK_RETURN then
      begin
        tmp := currentScore;
        tmp1 := lives;
        StateInit(ST_GAME);
        currentScore := tmp;
        lives := tmp1 + 1;
        playerLivesTxt := txt.Draw(playerLivesTxt, PChar('x' + IntToStr(lives)), 'Fixedsys', Rect(140, 385, 0, 0), $FFFFFFFF, 12); 
      end;
    ST_GAME_OVER:
      StateInit(ST_MENU);
  end;
end;

procedure AIEvent(param: DWORD); stdcall;
var
  i, j: DWORD;
  KilledCnt: Integer;
  tmpRect: TRect;
begin
  KilledCnt := 0;
  for i := 0 to 11 do
    for j := 0 to 4 do
      with enemyArray[i, j] do
      begin
        case AIState of
          AI_READY:
            begin
              if (Random(1000000) < 999510 - KilledCnt * 100) or Killed then
              begin
                if Killed then Inc(KilledCnt);
                Continue;
              end;
              AIState := AI_ATTACKING;
              AIBulletPos.X := enemyPos.X + i * 26;
              AIBulletPos.Y := enemyPos.Y + j * 18;
              BulletDraw := e2d.Draw(0, bulletsSpr, URect(AIBulletPos.X, AIBulletPos.Y, 6, 12),
                ANIM_START, 2 + _Type * 2, $FF000000, 1, 50, 3 + _Type * 2, True);
            end;
          AI_ATTACKING:
            begin
              Inc(AIBulletPos.Y, 2);
              BulletDraw := e2d.Draw(BulletDraw, bulletsSpr, URect(AIBulletPos.X, AIBulletPos.Y, 6, 12),
                ANIM_KEEP, 2 + _Type * 2, $FF000000, 1, 50, 3 + _Type * 2, True);
              if IntersectRect(tmpRect, Bounds(AIBulletPos.X, AIBulletPos.Y, 6, 12), Bounds(playerPos.X, playerPos.Y, 32, 20)) then
              begin
                if lives = 0 then
                begin
                  StateInit(ST_GAME_OVER);
                  exit;
                end;
                Dec(lives);
                e2d.DelDraw(BulletDraw);
                AIState := AI_READY;
                playerLivesTxt := txt.Draw(playerLivesTxt, PChar('x' + IntToStr(lives)), 'Fixedsys', Rect(140, 385, 0, 0), $FFFFFFFF, 12); 
              end;
              if AIBulletPos.Y >= 380 then
              begin
                e2d.DelDraw(BulletDraw);
                AIState := AI_READY;
              end;
            end;
        end;
      end;
end;

//         
procedure OnLoad;
var
  tmpPtr: Pointer;
begin
  ShowCursor(False);
  FSOUND_SetOutput(FSOUND_OUTPUT_WINMM);
  FSOUND_SetDriver(0);
  FSOUND_SetMixer(FSOUND_MIXER_QUALITY_AUTODETECT);
  FSOUND_Init(44100, 64, 0);
  Fs.SetBigFile('data.phf', $F2BE521C);
  tmpPtr := Fs.OpenFile('sound/shoot.wav');
  sShoot := FSOUND_Sample_Load(FSOUND_FREE, tmpPtr,
    FSOUND_2D or FSOUND_LOADMEMORY, 0, Fs.GetFileSize(tmpPtr));
  tmpPtr := Fs.OpenFile('sound/invaderkilled.wav');
  sKilled := FSOUND_Sample_Load(FSOUND_FREE, tmpPtr,
    FSOUND_2D or FSOUND_LOADMEMORY, 0, Fs.GetFileSize(tmpPtr));
  tmpPtr := Fs.OpenFile('sound/fastinvader1.wav');
  sMove[0] := FSOUND_Sample_Load(FSOUND_FREE, tmpPtr,
    FSOUND_2D or FSOUND_LOADMEMORY, 0, Fs.GetFileSize(tmpPtr));
  tmpPtr := Fs.OpenFile('sound/fastinvader2.wav');
  sMove[1] := FSOUND_Sample_Load(FSOUND_FREE, tmpPtr,
    FSOUND_2D or FSOUND_LOADMEMORY, 0, Fs.GetFileSize(tmpPtr));
  tmpPtr := Fs.OpenFile('sound/fastinvader3.wav');
  sMove[2] := FSOUND_Sample_Load(FSOUND_FREE, tmpPtr,
    FSOUND_2D or FSOUND_LOADMEMORY, 0, Fs.GetFileSize(tmpPtr));
  fpsTxt := 0;
  if ParamStr(1) = 'd' then Eng.SetDebugFlag(EF_H_ERR) else Eng.SetDebugFlag(EF_RELEASE);
  Timer.ModeSet(TMF_ENABLED);
  Eng.SetTextureFilter(TF_POINT);
  Eng.SetVideoMode(True, False, 60, 32, 16, 640, 480);
  Eng.SetScreenClearParam(True, 0);
  Eng.SetProcessProc(@Process);
  Inp.SetKbProc(@KbProc);
{  // 
  Fs.SetBigFile('data2.phf', $F2BE521C, True);
  hiScore := Fs.OpenFile('hiscore.raw', CREATE_IN_BIGFILE);
  hiScore := Fs.SetFileSize(hiScore, 4);
  Integer(hiScore^) := $FFF;
  Fs.CloseFile(hiScore);
  Fs.CreateDir('/sprites', CREATE_IN_BIGFILE);
  Fs.CreateDir('/sprites/enemy', CREATE_IN_BIGFILE);
  Fs.SaveFile(Fs.OpenFile('sprites/enemy/1.bmp'), 'sprites/enemy/1.bmp', CREATE_IN_BIGFILE);
  Fs.SaveFile(Fs.OpenFile('sprites/enemy/2.bmp'), 'sprites/enemy/2.bmp', CREATE_IN_BIGFILE);
  Fs.SaveFile(Fs.OpenFile('sprites/enemy/3.bmp'), 'sprites/enemy/3.bmp', CREATE_IN_BIGFILE);
  Fs.SaveFile(Fs.OpenFile('sprites/enemy/4.bmp'), 'sprites/enemy/4.bmp', CREATE_IN_BIGFILE);
  Fs.SaveFile(Fs.OpenFile('sprites/player.bmp'), 'sprites/player.bmp', CREATE_IN_BIGFILE);
  Fs.SaveFile(Fs.OpenFile('sprites/bullets.bmp'), 'sprites/bullets.bmp', CREATE_IN_BIGFILE);//
  Fs.CreateDir('/sound', CREATE_IN_BIGFILE);
  Fs.SaveFile(Fs.OpenFile('sound/shoot.wav'), 'sound/shoot.wav', CREATE_IN_BIGFILE);
  Fs.SaveFile(Fs.OpenFile('sound/invaderkilled.wav'), 'sound/invaderkilled.wav', CREATE_IN_BIGFILE);
  Fs.SaveFile(Fs.OpenFile('sound/fastinvader1.wav'), 'sound/fastinvader1.wav', CREATE_IN_BIGFILE);
  Fs.SaveFile(Fs.OpenFile('sound/fastinvader2.wav'), 'sound/fastinvader2.wav', CREATE_IN_BIGFILE);
  Fs.SaveFile(Fs.OpenFile('sound/fastinvader3.wav'), 'sound/fastinvader3.wav', CREATE_IN_BIGFILE);
  //}
  hiScore := Fs.OpenFile('hiscore.raw');
  enemySpr[0] := e2d.AddSprite('enemy1', 'sprites/enemy/1.bmp', UPoint(26, 18));
  enemySpr[1] := e2d.AddSprite('enemy2', 'sprites/enemy/2.bmp', UPoint(26, 18));
  enemySpr[2] := e2d.AddSprite('enemy3', 'sprites/enemy/3.bmp', UPoint(26, 18));
  enemySpr[3] := e2d.AddSprite('enemy4', 'sprites/enemy/4.bmp', UPoint(26, 18));
  playerSpr := e2d.AddSprite('player', 'sprites/player.bmp', UPoint(32, 20));
  bulletsSpr := e2d.AddSprite('bullets', 'sprites/bullets.bmp', UPoint(6, 12));
  playerBulletDrw := 0;
  enemyMover := Timer.Add(600, 0, False, @MoveEnemys);
  bulletMover := Timer.Add(10, 0, False, @MoveBullet);
  AItimer := Timer.Add(10, 0, False, @AIEvent);
  StateInit(ST_MENU);
end;

begin
  Load(16);
  OnLoad;
  Eng.Loop;
  FSOUND_Sample_Free(sShoot);
  FSOUND_Sample_Free(sKilled);
  FSOUND_Sample_Free(sMove[0]);
  FSOUND_Sample_Free(sMove[1]);
  FSOUND_Sample_Free(sMove[2]);
  FSOUND_Close();
  UnLoad;
end.
